// config: norepeat noautolaunch

#include "GetObjects.js"

function Update( factory )
{
	// Get the viewport to be used.
	var viewname = moi.ui.commandUI.silview.value;
	var viewport = moi.ui.mainWindow.viewpanel.getViewport( viewname );

	// Retrieve the camera frame, this has the camera at the origin, x to the right,
	// y upwards, and z pointing backwards.
	var frame = viewport.cameraFrame;
	
	// Set the camera on to the factory.
	factory.setInput( 1, frame.origin );

	// Set the forward direction on to the factory.
	var dir = frame.zaxis;
	dir.scale( -1.0 );
	factory.setInput( 2, dir );
	
	// Set the boolean for perspective on/off to the factory.	
	var isperspective = (viewport.projection == 'Perspective');
	factory.setInput( 3, isperspective );
	
	factory.update();
}

function DoSilhouette()
{
	var ui = moi.ui;

	var objectpicker = ui.createObjectPicker();
	objectpicker.allowBReps();
	objectpicker.allowFaces();
	if ( !GetObjects( objectpicker ) )
		return;

	var factory = moi.command.createFactory( 'silhouette' );
	factory.setInput( 0, objectpicker.objects );

	factory.disableUpdate( true );
	ui.bindUIToInput( 'includeedges', 'value', factory.getInput(4) );
	factory.disableUpdate( false );

	ui.beginUIUpdate();
	ui.hideUI( 'SelectObjectsPrompt' );
	ui.showUI( 'OptionsPrompt' );
	ui.showUI( 'SilhouetteOptions' );
	ui.endUIUpdate();

	Update( factory );

	var dialog = ui.commandDialog;
			
	while ( 1 )
	{
		if ( !dialog.waitForEvent() )
			return;
			
		if ( dialog.event == 'done' )
			break;
			
		if ( dialog.event == 'silview' || dialog.event == 'recalc' )
			Update( factory );
	}			
	
	factory.commit();
}

DoSilhouette();
